VERSION 2.00
Begin Form Introduction 
   Caption         =   "VB/ISAM SAMPLE PROGRAM 1 -- INTRODUCTION"
   ClientHeight    =   4620
   ClientLeft      =   1056
   ClientTop       =   1548
   ClientWidth     =   7476
   ControlBox      =   0   'False
   Height          =   5136
   Left            =   960
   LinkMode        =   1  'Source
   LinkTopic       =   "Form1"
   ScaleHeight     =   4620
   ScaleWidth      =   7476
   Top             =   1128
   Width           =   7668
   Begin CommandButton QuitButton 
      Caption         =   "Quit"
      Height          =   495
      Left            =   4200
      TabIndex        =   3
      Top             =   3960
      Width           =   2175
   End
   Begin CommandButton StartButton 
      Caption         =   "Start"
      Height          =   495
      Left            =   1200
      TabIndex        =   2
      Top             =   3960
      Width           =   2175
   End
   Begin Label Label5 
      Caption         =   "(Note that ""default directories"" can be tricky.  If in doubt, edit the code of the SAM1GLB.BAS module to redefine the global constant DATASETNAME to include a full pathname.)"
      Height          =   615
      Left            =   240
      TabIndex        =   6
      Top             =   3120
      Width           =   7095
   End
   Begin Label Label3 
      Caption         =   "When the program starts, it looks for the VB/ISAM dataset ""SAM1DAT"" in the default directory and creates it (as an empty dataset) if necessary.  When you quit the program, you're given the option of killing the dataset."
      Height          =   615
      Left            =   240
      TabIndex        =   4
      Top             =   2400
      Width           =   7215
   End
   Begin Label Label2 
      Caption         =   "The sample dataset records are keyed on Social Security Number (primary key) with secondary keys of name, job title, and department.  Other fields are nickname, salary, and golf score.  The program illustrates various ways of locating records."
      Height          =   855
      Left            =   240
      TabIndex        =   1
      Top             =   1440
      Width           =   7095
   End
   Begin Label Label4 
      Caption         =   "This program also doesn't illustrate the multi-user (SHARED) access modes available in VB/ISAM MU."
      Height          =   495
      Left            =   240
      TabIndex        =   5
      Top             =   960
      Width           =   7215
   End
   Begin Label Label1 
      Caption         =   "This program demonstrates the multiple-index capabilities of VB/ISAM (Version 2.0).  It is NOT intended to be a practical app, nor is it an example of particularly attractive screen design or first-class VB coding technique."
      Height          =   615
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   7215
   End
End
'See StartButton_Click

Sub QuitButton_Click ()

    End

End Sub

Sub StartButton_Click ()

    'Try to open SAM1DAT; if not present, then create it:

    rc = VmxOpen(DATASETNAME, SMALL_CACHE, READ_WRITE, handle, "")

    If rc <> VIS_OK Then

        If rc = VIS_ACCESS_DENIED Then
            MsgBox "VmxOpen of dataset SAM1DAT failed with a VIS_ACCESS_DENIED return code; please make sure you have SHARE.EXE loaded (see user's manual).", 16, "SAM1"
            End
        End If

        If rc <> VIS_DOS_ERROR Then
            MsgBox "VmxOpen of dataset SAM1DAT failed with return code " + VmxReturnCode$(rc), 16, "SAM1"
            End
        End If

        rc = VmxCreate(DATASETNAME, 11, 0&, 0, 0, RECORDFORMAT)
                            
                            'Social Security Number is 11 characters long.
                            'Note that RECORDFORMAT is defined in the Global
                            'module; also, to conform to good programming
                            'practice, the secondary index field numbers
                            'have also been defined as global constants,
                            'with meaningful word choices.  This is an
                            'important technique; go take a look.
        
        If rc <> VIS_OK Then
            If rc = VIS_ACCESS_DENIED Then
                MsgBox "VmxCreate of dataset SAM1DAT failed with a VIS_ACCESS_DENIED return code; see user's manual.", 16, "SAM1"
            Else
                MsgBox "Problem -- unable to create dataset SAM1DAT; VmxCreate returned code " + VmxReturnCode$(rc), 16, "SAM1"
            End If
            End
        End If
        
        rc = VmxOpen(DATASETNAME, SMALL_CACHE, READ_WRITE, handle, "")

        If rc <> VIS_OK Then
            MsgBox "Problem -- unable to open newly created dataset SAM1DAT", 16, "SAM1"
            End
        End If

    End If

    Introduction.Hide
    Main.Show

End Sub

